/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.awt.Color;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.LogWriter;
import noppes.npcs.client.Client;
import noppes.npcs.client.controllers.ClientCloneController;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNpcMobSpawner
extends GuiNPCInterface
implements IGuiData,
ICustomScrollListener {
    private static int showingClones = 0;
    private int activeTab = 1;
    private final int posX;
    private final int posY;
    private final int posZ;
    private int sel = -1;
    private GuiCustomScroll scroll;
    public EntityLivingBase selectNpc;

    public GuiNpcMobSpawner(int x, int y, int z) {
        this.xSize = 256;
        this.closeOnEsc = true;
        this.setBackground("menubg.png");
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                if (showingClones == 2) {
                    String sel = this.scroll.getSelected();
                    if (sel == null) {
                        return;
                    }
                    Client.sendData(EnumPacketServer.SpawnMob, true, this.posX, this.posY, this.posZ, sel, this.activeTab);
                    this.close();
                    break;
                }
                NBTTagCompound compound = this.getCompound();
                if (compound == null) {
                    return;
                }
                Client.sendData(EnumPacketServer.SpawnMob, false, this.posX, this.posY, this.posZ, compound);
                this.close();
                break;
            }
            case 2: {
                if (showingClones == 2) {
                    String sel = this.scroll.getSelected();
                    if (sel == null) {
                        return;
                    }
                    Client.sendData(EnumPacketServer.MobSpawner, true, this.posX, this.posY, this.posZ, sel, this.activeTab);
                    this.close();
                    break;
                }
                NBTTagCompound compound = this.getCompound();
                if (compound == null) {
                    return;
                }
                Client.sendData(EnumPacketServer.MobSpawner, false, this.posX, this.posY, this.posZ, compound);
                this.close();
                break;
            }
            case 3: {
                this.selectNpc = null;
                showingClones = 0;
                this.func_73866_w_();
                break;
            }
            case 4: {
                this.selectNpc = null;
                showingClones = 1;
                this.func_73866_w_();
                break;
            }
            case 5: {
                this.selectNpc = null;
                showingClones = 2;
                this.func_73866_w_();
                break;
            }
            case 6: {
                String name = this.scroll.getSelected();
                if (name == null || name.isEmpty()) {
                    return;
                }
                this.scroll.setSelect(this.scroll.getSelect() - 1);
                if (this.scroll.getSelect() < 0) {
                    if (this.scroll.getList() == null || this.scroll.getList().isEmpty()) {
                        this.scroll.setSelect(-1);
                    } else {
                        this.scroll.setSelect(0);
                    }
                }
                this.sel = this.scroll.getSelect();
                this.selectNpc = null;
                if (showingClones == 2) {
                    Client.sendData(EnumPacketServer.CloneRemove, this.activeTab, name);
                    return;
                }
                ClientCloneController.Instance.removeClone(name, this.activeTab);
                this.func_73866_w_();
                break;
            }
            default: {
                if (button.getID() <= 20) break;
                this.activeTab = button.getID() - 20;
                this.func_73866_w_();
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.subgui == null && this.player != null) {
            GlStateManager.func_179094_E();
            if (this.selectNpc != null) {
                this.drawNpc((Entity)this.selectNpc, 210, 130, 1.0f, (int)(3L * this.player.field_70170_p.func_82737_E() % 360L), 0, 0);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            Gui.func_73734_a((int)(this.guiLeft + 179), (int)(this.guiTop + 54), (int)(this.guiLeft + 242), (int)(this.guiTop + 142), (int)new Color(-8355712).getRGB());
            Gui.func_73734_a((int)(this.guiLeft + 180), (int)(this.guiTop + 55), (int)(this.guiLeft + 241), (int)(this.guiTop + 141), (int)new Color(-16777216).getRGB());
            GlStateManager.func_179121_F();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private NBTTagCompound getCompound() {
        String sel = this.scroll.getSelected();
        if (sel == null) {
            return null;
        }
        if (showingClones == 0) {
            return ClientCloneController.Instance.getCloneData((ICommandSender)this.player, sel, this.activeTab);
        }
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            if (!ent.getName().equals(this.scroll.getSelected())) continue;
            Entity entity = EntityList.func_188429_b((ResourceLocation)Objects.requireNonNull(ent.getRegistryName()), (World)Minecraft.func_71410_x().field_71441_e);
            if (!(entity instanceof EntityLivingBase)) break;
            NBTTagCompound compound = new NBTTagCompound();
            entity.func_184198_c(compound);
            return compound;
        }
        return null;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiTop += 10;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(165, 188);
        } else {
            this.scroll.clear();
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 26;
        this.scroll.setSelect(this.sel);
        this.addScroll(this.scroll);
        GuiMenuTopButton button = new GuiMenuTopButton(3, this.guiLeft + 4, this.guiTop - 17, "spawner.clones");
        this.addTopButton(button);
        button.active = showingClones == 0;
        button = new GuiMenuTopButton(4, button, "spawner.entities");
        this.addTopButton(button);
        button.active = showingClones == 1;
        button = new GuiMenuTopButton(5, button, "gui.server");
        this.addTopButton(button);
        button.active = showingClones == 2;
        this.addButton(new GuiNpcButton(1, this.guiLeft + 170, this.guiTop + 6, 82, 20, "spawner.spawn"));
        this.addButton(new GuiNpcButton(2, this.guiLeft + 170, this.guiTop + 146, 82, 20, "spawner.mobspawner"));
        if (showingClones == 0 || showingClones == 2) {
            int x = this.guiLeft;
            int y = this.guiTop + 4;
            for (int id = 1; id < 10; ++id) {
                this.addSideButton(new GuiMenuSideButton(20 + id, x, y + (id - 1) * 19, "Tab " + id));
            }
            this.addButton((IGuiNpcButton)new GuiNpcButton(6, this.guiLeft + 170, this.guiTop + 30, 82, 20, "gui.remove"));
            this.getSideButton(20 + this.activeTab).setActive(true);
            this.showClones();
        } else {
            this.showEntities();
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (i == 200 || i == 208 || i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() || i == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.resetEntity();
        }
    }

    private void resetEntity() {
        if (showingClones == 0) {
            NBTTagCompound npcNbt = ClientCloneController.Instance.getCloneData((ICommandSender)this.player, this.scroll.getSelected(), this.activeTab);
            if (npcNbt == null) {
                return;
            }
            Entity entity = EntityList.func_75615_a((NBTTagCompound)npcNbt, (World)Minecraft.func_71410_x().field_71441_e);
            if (entity instanceof EntityLivingBase) {
                this.selectNpc = (EntityLivingBase)entity;
            }
        } else if (showingClones == 1) {
            for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
                if (!ent.getName().equals(this.scroll.getSelected())) continue;
                Entity entity = EntityList.func_188429_b((ResourceLocation)Objects.requireNonNull(ent.getRegistryName()), (World)Minecraft.func_71410_x().field_71441_e);
                if (entity instanceof EntityLivingBase) {
                    this.selectNpc = (EntityLivingBase)entity;
                }
                return;
            }
        } else {
            Client.sendData(EnumPacketServer.GetClone, false, this.scroll.getSelected(), this.activeTab);
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.resetEntity();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_150297_b("NPCData", 10)) {
            this.selectNpc = (EntityNPCInterface)EntityList.func_75615_a((NBTTagCompound)compound.func_74775_l("NPCData"), (World)this.player.field_70170_p);
            return;
        }
        NBTTagList nbtList = compound.func_150295_c("List", 8);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            list.add(nbtList.func_150307_f(i));
        }
        this.scroll.setList(list);
        this.scroll.setSelect(this.sel);
    }

    private void showClones() {
        if (showingClones == 2) {
            Client.sendData(EnumPacketServer.CloneList, this.activeTab);
            return;
        }
        this.scroll.setList(ClientCloneController.Instance.getClones(this.activeTab));
        this.scroll.setSelect(this.sel);
        this.resetEntity();
    }

    private void showEntities() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            if (Objects.requireNonNull(ent.getRegistryName()).func_110624_b().equals("customnpcs")) continue;
            Class c = ent.getEntityClass();
            String name = ent.getName();
            try {
                if (classes.contains(c) || !EntityLiving.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                list.add(name);
                classes.add(c);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        this.scroll.setList(list);
        this.scroll.setSelect(this.sel);
    }
}

